## Gemini 2.5 Pro 实测：或将成为最实用的推理模型

Google 最新旗舰语言模型 Gemini 2.5 Pro 的发布，被吉卜力工作室 AI 图像风波所掩盖。也许是吸取了之前失败发布的教训，Google 谨慎地将其描述为"我们最智能的 AI 模型"，而不像其他 AI 实验室那样宣称自己的新模型是世界最佳。

然而，实际测试表明，Gemini 2.5 Pro 确实令人印象深刻，可能是目前最优秀的推理模型。这为许多新应用开辟了道路，并可能使 Google 在生成式 AI 竞赛中处于领先地位。

具备出色编程能力的超长上下文

Gemini 2.5 Pro 最突出的特点是其超长的上下文窗口和输出长度。该模型可以处理多达 100 万个 token (即将支持 200 万)，使其能够在需要时将多个长文档和完整的代码库装入提示中。该模型的输出限制为 64,000 个 token，而其他 Gemini 模型仅为 8,000 左右。

长上下文窗口也支持更长时间的对话，因为每次与推理模型的交互都可能产生数万个 token，特别是在涉及代码、图像和视频时（我在使用 Claude 3.7 Sonnet 时就遇到了这个问题，它的上下文窗口为 200,000 个 token）。

例如，软件工程师 Simon Willison 使用 Gemini 2.5 Pro 为他的网站创建了一个新功能。Willison 在博客中说："它分析了我的整个代码库，找出了所有需要更改的地方——总共 18 个文件，从最终的 PR 中可以看出。整个项目从开始到完成只花了约 45 分钟，平均每个需要修改的文件不到 3 分钟。我向它提出了很多其他编程挑战，而评估这些结果的瓶颈变成了我自己的理解能力！"

令人印象深刻的多模态推理

Gemini 2.5 Pro 在非结构化文本、图像和视频方面也表现出色。例如，我向它提供了我最近关于基于采样搜索的文章，并要求它创建一个描述文中算法的 SVG 图形。Gemini 2.5 Pro 正确地提取了文章中的关键信息，并为采样和搜索过程创建了一个流程图，甚至准确地呈现了条件步骤。（相比之下，同样的任务使用 Claude 3.7 Sonnet 需要多次交互，而且最终达到了 token 限制。）

生成的图像有一些视觉错误（箭头位置不正确）。为了改进效果，我接着用多模态提示测试了 Gemini 2.5 Pro，给它一个渲染后的 SVG 文件截图和代码，要求它进行改进。结果令人印象深刻，它纠正了箭头的问题，并提升了图表的视觉质量。

其他用户在多模态提示方面也有类似的体验。例如，在测试中，DataCamp 复现了 Google 博客中展示的跑步游戏示例，然后将代码和游戏视频录制提供给 Gemini 2.5 Pro，并要求它对游戏代码进行一些修改。该模型能够对视觉内容进行推理，找到需要更改的代码部分，并做出正确的修改。

然而值得注意的是，与其他生成模型一样，Gemini 2.5 Pro 也可能出错，比如修改不相关的文件和代码段。指令越精确，模型出错的风险就越低。

具有实用推理过程的数据分析

最后，我用我典型的混乱数据分析测试来评估 Gemini 2.5 Pro 的推理能力。我提供了一个包含从雅虎财经不同股票历史页面复制粘贴的纯文本和原始 HTML 数据混合文件。然后要求它计算从 2024 年 1 月到文件中最新日期，每月初投资 140 美元，平均分配到"超级七巨头"股票的投资组合价值。

模型正确识别了文件中需要的股票（亚马逊、苹果、英伟达、微软、特斯拉、Alphabet 和 Meta），从 HTML 数据中提取金融信息，并根据每月初的股票价格计算每次投资的价值。它以格式良好的表格形式呈现了每月的股票和投资组合价值，并提供了整个投资在期末的总价值明细。

更重要的是，我发现其推理过程非常实用。虽然不清楚 Google 是否展示 Gemini 2.5 Pro 的原始思维链 (CoT) token，但推理过程非常详细。你可以清楚地看到模型是如何对数据进行推理、提取不同信息片段，并在生成答案前计算结果的。这有助于排查模型的行为，并在其犯错时引导它朝正确的方向发展。

企业级推理？

关于 Gemini 2.5 Pro 的一个担忧是，它只能在推理模式下使用，这意味着即使对于可以直接回答的非常简单的提示，模型也会经历"思考"过程。

Gemini 2.5 Pro 目前处于预览版阶段。一旦完整模型发布并公布定价信息，我们将更好地了解基于该模型构建企业应用的成本。不过，随着推理成本持续下降，我们可以期待它在规模化应用中变得更加实用。

尽管 Gemini 2.5 Pro 的首次亮相可能不够引人注目，但其功能值得关注。其超大的上下文窗口、出色的多模态推理能力和详细的推理链，为从代码库重构到精细数据分析等复杂的企业工作负载提供了切实的优势。

> 来源：澎湃新闻
